/*---------------------------------------------------
 * AZERTY design
 * Olivier Pons - http://olivierpons.fr
 *                olivier dot pons at gmail dot com
 */
// Special KEYMAPPING for easy readability:
#define ERGODOX_KEYMAP( \
    L01,L02,L03,L04,L05,L06,L07,    R01,R02,R03,R04,R05,R06,R07, \
    L08,L09,L10,L11,L12,L13,L14,    R08,R09,R10,R11,R12,R13,R14, \
    L15,L16,L17,L18,L19,L20,            R15,R16,R17,R18,R19,R20, \
    L21,L22,L23,L24,L25,L26,L27,    R21,R22,R23,R24,R25,R26,R27, \
    L28,L29,L30,L31,L32,                    R28,R29,R30,R31,R32, \
                         L33,L34,   R33,R34, \
                             L35,   R35, \
                     L36,L37,L38,   R36,R37,R38 \
    ) \
    KEYMAP(L01,L02,L03,L04,L05,L06,L07,L08,L09,L10,L11, \
        L12,L13,L14,L15,L16,L17,L18,L19,L20,L21,L22, \
        L23,L24,L25,L26,L27,L28,L29,L30,L31,L32,L33, \
        L34,L35,L36,L37,L38,R01,R02,R03,R04,R05,R06, \
        R07,R08,R09,R10,R11,R12,R13,R14,R15,R16,R17, \
        R18,R19,R20,R21,R22,R23,R24,R25,R26,R27,R28, \
        R29,R30,R31,R32,R33,R34,R35,R36,R37,R38 \
    )
static const uint8_t PROGMEM keymaps[][MATRIX_ROWS][MATRIX_COLS] = {
    /*
     * Keymap: Default Layer in AZERTY / Layer0: default
     */
    ERGODOX_KEYMAP( // Layer 0 : (key) and (shifted key)
    /* ,--------------------------------------------------.           ,--------------------------------------------------. */
    /* |    Esc |  & 1 |  é 2 |  " 3 |  ' 4 |  ( 5 |  ^L3 |           | Pscr |  - 6 |  è 7 |  _ 8 |  ç 9 |  à 0 |  Bspc  | */
            ESC ,   1  ,   2  ,   3  ,   4  ,   5  ,  FN3 ,             PSCR ,   6  ,   7  ,   8  ,   9  ,   0  ,  BSPC  ,
    /* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    /* |   Tab  |  a A |  z Z |  e E |  r R |  t T | Bspc |           |  ~L1 |  y Y |  u U |  i I |  o O |  p P |   ^ ¨  | */
            TAB ,   Q  ,   W  ,   E  ,   R  ,   T  , BSPC ,              FN1 ,   Y  ,   U  ,   I  ,   O  ,   P  ,   LBRC ,
    /* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    /* |    .   |  q Q |  s S |  d D |  f F |  g G |------|           |------|  h H |  j J |  k K |  l L |  m M |  Enter | */
          PDOT  ,   A  ,   S  ,   D  ,   F  ,   G  ,                             H  ,   J  ,   K  ,   L  , SCLN ,   ENT  ,
    /* |--------+------+------+------+------+------|  Ent |           |  Ins |------+------+------+------+------+--------| */
    /* |  Lsft  |  w W |  x X |  c C |  v V |  b B |      |           |      |  n N |  , ? |  ; . |  : / |  ! § |  Rsft  | */
          LSFT  ,   Z  ,   X  ,   C  ,   V  ,   B  ,  ENT ,              INS ,   N  ,   M  , COMM ,  DOT , SLASH,  RSFT  ,
    /* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    /*   | LCtl | LGui | LAlt | Lsft |  Del |                                       |  Spc |  Spc | RAlt | RGui | RCtl |   */
           LCTL , LGUI , LALT , LSFT ,  DEL ,                                          SPC ,  SPC , RALT , RGUI , RCTL ,
    /*   `----------------------------------'                                       `----------------------------------'   */
    /*                                        ,-------------.       ,-------------.                                        */
    /*                                        | Copy | Pste |       | Nbsp |   F8 |                                        */
                                                FN25 , FN27 ,         FN17 ,   F8 ,
    /*                                 ,------|------|------|       |------+------+------.                                 */
    /*                                 |      |      | Cut  |       |   <> |      |      |                                 */
                                                       FN26 ,         FN15 ,
    /*                                 |  ~L1 |  ~L2 |------|       |------|  ~L2 |  ~L1 |                                 */
    /*                                 |      |      |  Del |       |  </> |      |      |                                 */
                                          FN1 ,  FN2 ,  DEL ,         FN16 ,  FN2 ,  FN1
    /*                                 `--------------------'       `--------------------'                                 */
    ),

    ERGODOX_KEYMAP( // Layer 1
    // left hand = chars for developper                                right hand = moving cursor + cut/copy/paste
    /* ,--------------------------------------------------.           ,--------------------------------------------------. */
    /* |   Esc  |   F1 |   F2 |   F3 |   F4 |   F5 |   F6 |           |   F7 |   F8 |   F9 |  F10 |  F11 |  F12 |  Bspc  | */
           ESC  ,   F1 ,   F2 ,   F3 ,   F4 ,   F5 ,   F6 ,               F7 ,   F8 ,   F9 ,  F10 ,  F11 ,  F12 ,  BSPC  ,
    /* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    /* |   Tab  |   \  |   <  |   _  |   >  |   |  |   $  |           |  Cut | Copy | Ct-← |   ↑  | Ct-→ | Pste |   ^ ¨  | */
            TAB , FN12 , NUBS ,   8  , FN23 , FN10 , RBRC ,             FN26 , FN25 , FN28 ,  UP  , FN29 , FN27 ,   LBRC ,
    /* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    /* |     -  |   {  |   (  |   /  |   )  |   }  |------|           |------| Home |   ←  |   ↓  |   →  |  End |  Enter | */
           TRNS ,  FN8 ,   5  , FN24 , MINS , FN30 ,                           HOME , LEFT , DOWN , RGHT ,  END ,   ENT   ,
    /* |--------+------+------+------+------+------|   =  |           |  -   |------+------+------+------+------+--------| */
    /* |  Lsft  |   #  |   [  |   *  |   ]  |   @  |      |           |      |   -  | PgUp |  Ins | PgDn | PEnt |  Rsft  | */
          LSFT  ,  FN7 ,  FN9 , BSLS , FN31 , FN14 ,  EQL ,             TRNS , TRNS , PGUP ,  INS , PGDN , PENT ,  RSFT  ,
    /* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    /*   | LCtl | LGui | LAlt |   ~  | Lsft |                                       |   0  |   .  | RAlt | RGui | RCtl |   */
           LCTL , LGUI , LALT ,  FN6 , LSFT ,                                          P0  , PDOT , RALT , RGUI , RCTL ,
    /*   `----------------------------------'                                       `----------------------------------'   */
    /*                                        ,-------------.       ,-------------.                                        */
    /*                                        |   -  |   -  |       |   -  |    - |                                        */
                                                TRNS , TRNS ,         TRNS , TRNS ,
    /*                                 ,------|------|------|       |------+------+------.                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                                       TRNS ,         TRNS ,
    /*                                 |   -  |   -  |------|       |------|   -  |   -  |                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                         TRNS , TRNS , TRNS ,         TRNS , TRNS , TRNS
    /*                                 `--------------------'       `--------------------'                                 */

    ),

    ERGODOX_KEYMAP( // Layer 2
    // left hand = accented chars chars i could not put before         right hand = full keypad
    /* ,--------------------------------------------------.           ,--------------------------------------------------. */
    /* |    Esc |   -  |   -  |   -  |   -  |   -  |   -  |           |   -  |   -  | NLCK |   /  |   *  |   -  |  Bspc  | */
            ESC , TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,             TRNS , TRNS , NLCK , PSLS , PAST , PMNS ,  BSPC  ,
    /* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    /* |   Tab  |   -  |   ô  |   â  |   à  |   -  |   -  |           |   -  |   -  |   7  |   8  |   9  |   +  |   ^ ¨  | */
            TAB , TRNS , FN18 , FN19 ,   0  , TRNS , TRNS ,             TRNS , TRNS ,  P7  ,  P8  ,  P9  , PPLS ,   LBRC ,
    /* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    /* |     -  |   ë  |   é  |   -  |   è  |   -  |------|           |------|   -  |   4  |   5  |   6  |   +  |  PEnt | */
           TRNS , FN20 ,   2  , TRNS ,   7  , TRNS ,                           TRNS ,  P4  ,  P5  ,  P6  , PPLS ,  PENT  ,
    /* |--------+------+------+------+------+------|   -  |           |   %  |------+------+------+------+------+--------| */
    /* |  Lsft  |   -  |   -  |   û  |   ù  |   -  |      |           |      |   -  |   1  |   2  |   3  | PEnt |  Rsft  | */
          LSFT  , TRNS , TRNS , FN22 , QUOT , TRNS , TRNS ,             FN21 , TRNS ,  P1  ,  P2  ,  P3  , PENT ,  RSFT  ,
    /* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    /*   | LCtl | LGui | LAlt |  Spc | Lsft |                                       |   0  |   .  | RAlt | RGui | RCtl |   */
           LCTL , LGUI , LALT ,  SPC , LSFT ,                                          P0  , PDOT , RALT , RGUI , RCTL ,
    /*   `----------------------------------'                                       `----------------------------------'   */
    /*                                        ,-------------.       ,-------------.                                        */
    /*                                        |   -  |   -  |       |   -  |    - |                                        */
                                                TRNS , TRNS ,         TRNS , TRNS ,
    /*                                 ,------|------|------|       |------+------+------.                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                                       TRNS ,         TRNS ,
    /*                                 |   -  |   -  |------|       |------|   -  |   -  |                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                         TRNS , TRNS , TRNS ,         TRNS , TRNS , TRNS
    /*                                 `--------------------'       `--------------------'                                 */

    ),

    ERGODOX_KEYMAP( // Layer 3 for my sons - Trackmania
    // left hand - my son Thibault                                    right hand - my daughter Ines
    /* ,--------------------------------------------------.           ,--------------------------------------------------. */
    /* |    Esc |   -  |   -  |   -  |   -  |   -  |  ^L3 |           |  ^L4 |   -  |   -  |   -  |   -  |   -  |    -   | */
            ESC ,   NO ,   NO ,   NO ,   NO ,   NO ,  FN3 ,              FN4 ,   NO ,   NO ,   NO ,   NO ,   NO ,    NO  ,
    /* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    /* |    -   | Bspc |  z Z |  Del |   -  |   -  |   -  |           |   -  |   -  | Bspc |   ↑  |  Del |   -  |    -   | */
            NO  , BSPC ,   W  ,  DEL ,   NO ,   NO ,   NO ,               NO ,   NO , BSPC ,  UP  ,  DEL ,   NO ,    NO  ,
    /* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    /* |    -   |  q Q |  s S |  s S |   -  |   -  |------|           |------|   -  |   ←  |   ↓  |   →  |   -  |  Enter | */
            NO  ,   A  ,   S  ,   S  ,   NO ,   NO ,                             NO , LEFT , DOWN , RGHT ,   NO ,   ENT  ,
    /* |--------+------+------+------+------+------|   -  |           |   -  |------+------+------+------+------+--------| */
    /* |    -   |   -  |   -  |   -  |   -  |   -  |      |           |      |   -  |   -  |   -  |   -  |   -  |    -   | */
            NO  ,   NO ,   NO ,   NO ,   NO ,   NO ,   NO ,               NO ,   NO ,   NO ,   NO ,   NO ,   NO ,    NO  ,
    /* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    /*   |   -  |   -  | LAlt |    - |   -  |                                       |   -  |    - |   -  |   -  |   -  |   */
             NO ,   NO , LALT ,   NO ,   NO ,                                           NO ,    NO,   NO ,   NO ,   NO ,
    /*   `----------------------------------'                                       `----------------------------------'   */
    /*                                        ,-------------.       ,-------------.                                        */
    /*                                        |   -  |   -  |       |   -  |   -  |                                        */
                                                  NO ,   NO ,           NO ,   NO ,
    /*                                 ,------|------|------|       |------+------+------.                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                                         NO ,           NO ,
    /*                                 |   -  |   -  |------|       |------|   -  |   -  |                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                           NO ,   NO ,   NO ,           NO ,   NO ,   NO
    /*                                 `--------------------'       `--------------------'                                 */
    ),

    ERGODOX_KEYMAP( // Layer 4 for Orcs Must Die 2
    // left hand                                                      right hand
    /* ,--------------------------------------------------.           ,--------------------------------------------------. */
    /* |    Esc |  & 1 |  é 2 |  " 3 |  ' 4 |  ( 5 |   -  |           |  ^L4 |   -  |   -  |   -  |   -  |   -  |    -   | */
            ESC ,   1  ,   2  ,   3  ,   4  ,   5  ,   NO ,              FN4 ,   NO ,   NO ,   NO ,   NO ,   NO ,    NO  ,
    /* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    /* |   Tab  |  - 6 |  è 7 |  _ 8 |  ç 9 |  à 0 |   -  |           |   -  |   -  | Bspc |   ↑  |  Del |   -  |    -   | */
            TAB ,   6  ,   7  ,   8  ,   9  ,   0  , TRNS ,               NO ,   NO , BSPC ,  UP  ,  DEL , TRNS ,    NO  ,
    /* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    /* |    -   |   -  |  z Z |  e E |  r R |  g G |------|           |------|   -  |   ←  |   ↓  |   →  |   -  |    -   | */
            NO  ,   NO ,   W  ,   E  ,   R  ,   G  ,                             NO , LEFT , DOWN , RGHT , TRNS ,    NO  ,
    /* |--------+------+------+------+------+------|   -  |           |   -  |------+------+------+------+------+--------| */
    /* |  Lsft  |  q Q |  s S |  d D |   -  |  b B |      |           |      |   -  |   -  |   -  |   -  |   -  |    -   | */
          LSFT  ,   A  ,   S  ,   D  ,   NO ,   B  ,   NO ,               NO ,   NO ,   NO ,   NO ,   NO ,   NO ,    NO  ,
    /* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    /*   | LCtl | LGui | LAlt |  Spc | Lsft |                                       |  Spc |  Spc | RAlt | RGui | RCtl |   */
           LCTL , LGUI , LALT ,  SPC , LSFT ,                                          SPC ,  SPC , RALT , RGUI , RCTL ,
    /*   `----------------------------------'                                       `----------------------------------'   */
    /*                                        ,-------------.       ,-------------.                                        */
    /*                                        |   -  |   -  |       |   -  |   -  |                                        */
                                                  NO ,   NO ,           NO ,   NO ,
    /*                                 ,------|------|------|       |------+------+------.                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                                         NO ,           NO ,
    /*                                 |  Spc |   -  |------|       |------|   -  |   -  |                                 */
    /*                                 |      |      |   -  |       |   -  |      |      |                                 */
                                          SPC ,   NO ,   NO ,           NO ,   NO ,   NO
    /*                                 `--------------------'       `--------------------'                                 */
    ),



// templates to copy from

    //ERGODOX_KEYMAP(  // LayerN: transparent on edges + hard-defined Ctl, Gui, Alt, all others are empty
    ///* ,--------------------------------------------------.           ,--------------------------------------------------. */
    ///* |   ~    |   1  |   2  |   3  |   4  |   5  |   \  |           |   -  |   6  |   7  |   8  |   9  |   0  |   =    | */
    //       TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,              NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  TRNS  ,
    ///* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    ///* | Tab    |   Q  |   W  |   E  |   R  |   T  | ~L5  |           | ~L6  |   Y  |   U  |   I  |   O  |   P  |   [    | */
    //       TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  , TRNS ,             TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  TRNS  ,
    ///* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    ///* | Tab/Shf|   A  |   S  |   D  |   F  |   G  |------|           |------|   H  |   J  |   K  |   L  |   ;  |   '    | */
    //       TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,                            NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  TRNS  ,
    ///* |--------+------+------+------+------+------|  L0  |           | ~L7  |------+------+------+------+------+--------| */
    ///* | LCtrl  |   Z  |   X  |   C  |   V  |   B  |      |           |      |   N  |   M  |   ,  |   .  |   /  |   ]    | */
    //       TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  , TRNS ,             TRNS ,  NO  ,  NO  ,  NO  ,  NO  ,  NO  ,  TRNS  ,
    ///* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    ///*   | LCtl | LGui | RAlt |  Spc |  Spc |                                       |  Spc |  Spc | RAlt | RGui | RCtl |   */
    //       LCTL , LGUI , RALT ,  SPC ,  SPC ,                                          SPC ,  SPC , RALT , RGUI , RCTL ,
    ///*   `----------------------------------'                                       `----------------------------------'   */
    ///*                                        ,-------------.       ,-------------.                                        */
    ///*                                        | +L2  | Home |       | PgUp | Del  |                                        */
    //                                            TRNS , TRNS ,         TRNS , TRNS ,
    ///*                                 ,------|------|------|       |------+------+------.                                 */
    ///*                                 |      |      |  End |       | PgDn |      |      |                                 */
    //                                                   TRNS ,         TRNS ,
    ///*                                 | BkSp |  ESC |------|       |------| Enter| Space|                                 */
    ///*                                 |      |      |  Spc |       | Ins  |      |      |                                 */
    //                                     TRNS , TRNS , TRNS ,         TRNS , TRNS , TRNS
    ///*                                 `--------------------'       `--------------------'                                 */
    //),

    //ERGODOX_KEYMAP( // LayerN: fully transparent
    ///* ,--------------------------------------------------.           ,--------------------------------------------------. */
    ///* |    -   |   -  |   -  |   -  |   -  |   -  |   -  |           |   -  |   -  |   -  |   -  |   -  |   -  |   -    | */
    //       TRNS , TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,             TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,  TRNS  ,
    ///* |--------+------+------+------+------+-------------|           |------+------+------+------+------+------+--------| */
    ///* |    -   |   -  |   -  |   -  |   -  |   -  |   -  |           |   -  |   -  |   -  |   -  |   -  |   -  |   -    | */
    //       TRNS , TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,             TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,  TRNS  ,
    ///* |--------+------+------+------+------+------|      |           |      |------+------+------+------+------+--------| */
    ///* |    -   |   -  |   -  |   -  |   -  |   -  |------|           |------|   -  |   -  |   -  |   -  |   -  |   -    | */
    //       TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,                           TRNS , TRNS , TRNS , TRNS , TRNS ,  TRNS  ,
    ///* |--------+------+------+------+------+------|   -  |           |   -  |------+------+------+------+------+--------| */
    ///* |    -   |   -  |   -  |   -  |   -  |   -  |      |           |      |   -  |   -  |   -  |   -  |   -  |   -    | */
    //       TRNS , TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,             TRNS , TRNS , TRNS , TRNS , TRNS , TRNS ,  TRNS  ,
    ///* `--------+------+------+------+------+-------------'           `-------------+------+------+------+------+--------' */
    ///*   |  -   |   -  |   -  |   -  |   -  |                                       |   -  |   -  |   -  |   -  |   -  |   */
    //       TRNS , TRNS , TRNS , TRNS , TRNS ,                                         TRNS , TRNS , TRNS , TRNS , TRNS ,
    ///*   `----------------------------------'                                       `----------------------------------'   */
    ///*                                        ,-------------.       ,-------------.                                        */
    ///*                                        |   -  |   -  |       |   -  |   -  |                                        */
    //                                            TRNS , TRNS ,         TRNS , TRNS ,
    ///*                                 ,------|------|------|       |------+------+------.                                 */
    ///*                                 |      |      |   -  |       |   -  |      |      |                                 */
    //                                                   TRNS ,         TRNS ,
    ///*                                 |   -  |   -  |------|       |------|   -  |   -  |                                 */
    ///*                                 |      |      |   -  |       |   -  |      |      |                                 */
    //                                     TRNS , TRNS , TRNS ,         TRNS , TRNS , TRNS
    ///*                                 `--------------------'       `--------------------'                                 */
    //),

};

/* id for user defined functions & macros */
enum function_id {
    TEENSY_KEY,
    CUSTOM_KEY,
    L_CTRL_ALT_ENT,
    R_CTRL_ALT_ENT,
};

enum macro_id {

    MACRO_ID_LTGT,
    MACRO_ID_LTGT_SLASH,
    MACRO_ID_NBSP,

    MACRO_ID_O_CIRC,
    MACRO_ID_A_CIRC,
    MACRO_ID_E_UML,
    MACRO_ID_E_CIRC,
    MACRO_ID_U_CIRC,
};

/*
 * Fn action definition
 */
static const uint16_t PROGMEM fn_actions[] = {
    [ 0] = ACTION_FUNCTION(TEENSY_KEY),           // FN0  - Teensy key
    [ 1] = ACTION_LAYER_MOMENTARY(1),             // FN1 -
    [ 2] = ACTION_LAYER_MOMENTARY(2),             // FN2 -
    [ 3] = ACTION_LAYER_TOGGLE(3),                // FN3 - Go to layer 3

    [ 4] = ACTION_LAYER_TOGGLE(4),                // FN4 - Go to layer 4
    [ 5] = ACTION_LAYER_TOGGLE(0),                // FN1 - Go back to layer 0

    // Un-productive french keyboard => nicer shortcuts here!
    [ 6] = ACTION_MODS_KEY(MOD_RALT, KC_2),      // FN6  - ~ (tilde)
    [ 7] = ACTION_MODS_KEY(MOD_RALT, KC_3),      // FN7  - # (sharp)
    [ 8] = ACTION_MODS_KEY(MOD_RALT, KC_4),      // FN8  - { (bracket left)
    [ 9] = ACTION_MODS_KEY(MOD_RALT, KC_5),      // FN9  - [ (parenth. left)
    [10] = ACTION_MODS_KEY(MOD_RALT, KC_6),      // FN10 - | (pipe)
    [11] = ACTION_MODS_KEY(MOD_RALT, KC_7),      // FN11 - ` (backquote)
    [12] = ACTION_MODS_KEY(MOD_RALT, KC_8),      // FN12 - \ (backslash)
    [13] = ACTION_MODS_KEY(MOD_RALT, KC_9),      // FN13 - ^ (exponent)
    [14] = ACTION_MODS_KEY(MOD_RALT, KC_0),      // FN14 - @ (arobace)

    [15] = ACTION_MACRO(MACRO_ID_LTGT),          // FN15
    [16] = ACTION_MACRO(MACRO_ID_LTGT_SLASH),    // FN16
    [17] = ACTION_MACRO(MACRO_ID_NBSP),          // FN17

    [18] = ACTION_MACRO(MACRO_ID_O_CIRC),        // FN18
    [19] = ACTION_MACRO(MACRO_ID_A_CIRC),        // FN19
    [20] = ACTION_MACRO(MACRO_ID_E_UML),         // FN20
    [21] = ACTION_MODS_KEY(MOD_RSFT, KC_QUOT),   // FN21 - % (percent)
    [22] = ACTION_MACRO(MACRO_ID_U_CIRC),        // FN22
    [23] = ACTION_MODS_KEY(MOD_RSFT, KC_NUBS),   // FN23 - > (greater)
    [24] = ACTION_MODS_KEY(MOD_RSFT, KC_DOT),    // FN24 - / (slash)
    [25] = ACTION_MODS_KEY(MOD_LCTL, KC_INSERT), // FN25 - Copy
    [26] = ACTION_MODS_KEY(MOD_RSFT, KC_DELETE), // FN26 - Cut
    [27] = ACTION_MODS_KEY(MOD_RSFT, KC_INSERT), // FN27 - Paste
    [28] = ACTION_MODS_KEY(MOD_RCTL, KC_LEFT),   // FN28
    [29] = ACTION_MODS_KEY(MOD_RCTL, KC_RIGHT),  // FN29
    [30] = ACTION_MODS_KEY(MOD_RALT, KC_EQL),    // FN30 - }
    [31] = ACTION_MODS_KEY(MOD_RALT, KC_MINS),   // FN31 - ]

};

#define MACRO_LTGT       MACRO( T(NUBS), D(RSFT), T(NUBS), U(RSFT), T(LEFT), END)
#define MACRO_LTGT_SLASH MACRO( T(NUBS), D(RSFT), T(DOT), T(NUBS), U(RSFT), T(LEFT), END)
#define MACRO_NBSP       MACRO( T(1), T(N), T(B), T(S), T(P), T(COMM), END)

#define MACRO_O_CIRC  MACRO( T(LBRC), T(O), END)
#define MACRO_A_CIRC  MACRO( T(LBRC), T(Q), END)
#define MACRO_E_UML   MACRO( D(RSFT), T(LBRC), U(RSFT), T(E), END)
#define MACRO_E_CIRC  MACRO( T(LBRC), T(E), END)
#define MACRO_U_CIRC  MACRO( T(LBRC), T(U), END)

const macro_t *action_get_macro(keyrecord_t *record, uint8_t id, uint8_t opt) {
    if (record->event.pressed) {
        switch (id) {

            case MACRO_ID_LTGT: return MACRO_LTGT;
            case MACRO_ID_LTGT_SLASH: return MACRO_LTGT_SLASH;
            case MACRO_ID_NBSP: return MACRO_NBSP;

            case MACRO_ID_O_CIRC: return MACRO_O_CIRC;
            case MACRO_ID_A_CIRC: return MACRO_A_CIRC;
            case MACRO_ID_E_UML: return MACRO_E_UML;
            case MACRO_ID_E_CIRC: return MACRO_E_CIRC;
            case MACRO_ID_U_CIRC: return MACRO_U_CIRC;

        }
    }
    return MACRO_NONE;
}

#define FN_ACTIONS_SIZE         (sizeof(fn_actions)   / sizeof(fn_actions[0]))

/* translates Fn keycode to action */
action_t keymap_fn_to_action(uint8_t keycode)
{
    action_t action;
    action.code = ACTION_NO;
    //j'ai voulu reprendre le code de keymap_cub.h pour
    //mettre un "pack" de nouvelles fonctions pour une nouvelle couche,
    //mais ça ne fonctionne pas, alors je le laisse en commentaire,
    //et si vous voulez l'améliorer, ou carrément vous en servir et
    //le faire fonctionner, et si vous y arrivez, n'hésitez pas à
    //revenir vers moi :
    //if ((layer == 3) && (FN_INDEX(keycode) < FN_ACTIONS_LAYER_3_SIZE)) {
    //    action.code = pgm_read_word(&fn_actions_layer_3[FN_INDEX(keycode)]);
    //}
    // by default, use fn_actions from default layer 0
    // this is needed to get mapping for same key, that was used switch to some layer,
    // to have possibility to switch layers back
    if ((action.code == ACTION_NO) && (FN_INDEX(keycode) < FN_ACTIONS_SIZE)) {
        action.code = pgm_read_word(&fn_actions[FN_INDEX(keycode)]);
    }
    return action;
}
